//
//  WXKMailWindowController_IO.m
//  AnotherKyoponUtilities
//
//  Created by FUJIDANA on 06/09/02.
//  Copyright 2006 FUJIDANA. All rights reserved.
//

#import "WXKMailWindowController.h"
#import "WXKMail.h"


@implementation WXKMailWindowController (ImportExport)


+ (NSDateFormatter *)sharedDateFormatterForMBox
{
	static NSDateFormatter *dateFormatterForMBox;
	if (dateFormatterForMBox == nil) {
		NSLocale *POSIXLocale = [[[NSLocale alloc] initWithLocaleIdentifier:@"en_US_POSIX"] autorelease];
		
		dateFormatterForMBox = [[NSDateFormatter alloc] init];
		[dateFormatterForMBox setLocale:POSIXLocale];
		[dateFormatterForMBox setDateFormat:@"EEE MMM dd HH:mm:ss yyyy"];
		[dateFormatterForMBox setTimeZone:[NSTimeZone timeZoneForSecondsFromGMT:0]];
	}
	return dateFormatterForMBox;
}

- (void)writeMboxOfMails:(NSArray *)mails toDirectory:(NSString *)directory
{
	NSManagedObject	  *mail;
	NSEnumerator      *enumerator          = [mails objectEnumerator];
	NSAutoreleasePool *pool;
	NSString          *extraHeader;
	
	NSMutableData     *lightMailInboxData  = [NSMutableData dataWithCapacity:1024];
	NSMutableData     *lightMailOutboxData = [NSMutableData dataWithCapacity:1024];
	NSMutableData     *emailInboxData      = [NSMutableData dataWithCapacity:65535];
	NSMutableData     *emailOutboxData     = [NSMutableData dataWithCapacity:65535];
	
	while (mail = [enumerator nextObject]) {
		pool = [[NSAutoreleasePool alloc] init];
		
		if ([[[mail entity] name] isEqual:@"LightMail"]) {
//			NSString *dateString = [[mail valueForKey:@"date"] descriptionWithCalendarFormat:@"%a %b %e %H:%M:%S %Y" timeZone:nil locale:nil];
			NSDate *date = [mail valueForKey:@"date"];
			NSString *dateString = nil;
			if (date) {
				dateString = [[[self class] sharedDateFormatterForMBox] stringFromDate:date];
			}
			
			extraHeader = [NSString stringWithFormat:@"From %@ %@\r\n"
									@"X-KYOPON-LIGHT: %d, %d, %d, %s\r\n"
									  @"Content-Type: text/plain; charset=Shift-JIS\r\n"
											  @"Date: %@\r\n"
											  @"From: %@\r\n"
												@"To: %@\r\n\r\n",
				[mail valueForKey:@"from"],
				(dateString ? dateString : @""),
				[[mail valueForKeyPath:@"folder.order"] intValue],
				[[mail valueForKey:@"index"] intValue],
				[[mail valueForKey:@"status"] intValue],
				([[mail valueForKey:@"secured"] boolValue] ? "ON": "OFF"),
				(dateString ? dateString : @""),
				[mail valueForKey:@"from"],
				[mail valueForKey:@"to"]];
			
			if ([[mail valueForKeyPath:@"folder.order"] intValue] == WXKMailInboxMailBox) {
				[lightMailInboxData appendData:[extraHeader dataUsingEncoding:NSShiftJISStringEncoding]];
				[lightMailInboxData appendData:[mail valueForKey:@"message"]];
				[lightMailInboxData appendData:[@"\r\n\r\n" dataUsingEncoding:NSShiftJISStringEncoding]];
			} else {
				[lightMailOutboxData appendData:[extraHeader dataUsingEncoding:NSShiftJISStringEncoding]];
				[lightMailOutboxData appendData:[mail valueForKey:@"message"]];
				[lightMailOutboxData appendData:[@"\r\n\r\n" dataUsingEncoding:NSShiftJISStringEncoding]];
			}
		} else if ([[[mail entity] name] isEqual:@"EMail"]) {
			NSDate *date = [mail valueForKey:@"date"];
			NSString *dateString = nil;
			if (date) {
				dateString = [[[self class] sharedDateFormatterForMBox] stringFromDate:date];
			}
			
			extraHeader = [NSString stringWithFormat:@"From %@ %@\r\nX-KYOPON-MAIL: %d, %d, %d, %s\r\n",
				[mail valueForKey:@"from"],
				(dateString ? dateString : @""),
//				[[mail valueForKey:@"date"] descriptionWithCalendarFormat:@"%a %b %e %H:%M:%S %Y" timeZone:nil locale:nil],
				[[mail valueForKeyPath:@"folder.order"] intValue],
				[[mail valueForKey:@"index"] intValue],
				[[mail valueForKey:@"status"] intValue],
				[[mail valueForKey:@"secured"] boolValue] ? "ON": "OFF"];
			
			if ([[mail valueForKeyPath:@"folder.order"] intValue] == WXKMailInboxMailBox) {
				[emailInboxData appendData:[extraHeader dataUsingEncoding:NSASCIIStringEncoding]];
				[emailInboxData appendData:[mail valueForKey:@"message"]];
				[emailInboxData appendData:[@"\r\n" dataUsingEncoding:NSASCIIStringEncoding]];
			} else {
				[emailOutboxData appendData:[extraHeader dataUsingEncoding:NSASCIIStringEncoding]];
				[emailOutboxData appendData:[mail valueForKey:@"message"]];
				[emailOutboxData appendData:[@"\r\n" dataUsingEncoding:NSASCIIStringEncoding]];
			}
		}
		[pool release];
	}
	
	if ([emailInboxData length] != 0) {
		[emailInboxData writeToFile:[directory stringByAppendingPathComponent:@"emailInbox.mbox"]
						 atomically:YES];
	}
	if ([emailOutboxData length] != 0) {
		[emailOutboxData writeToFile:[directory stringByAppendingPathComponent:@"emailOutbox.mbox"]
						  atomically:YES];
	}
	if ([lightMailInboxData length] != 0) {
		[lightMailInboxData writeToFile:[directory stringByAppendingPathComponent:@"lightMailInbox.mbox"]
							 atomically:YES];
	}
	if ([lightMailOutboxData length] != 0) {
		[lightMailOutboxData writeToFile:[directory stringByAppendingPathComponent:@"lightMailOutbox.mbox"]
							  atomically:YES];
	}
}

- (void)writeMailsAsRFC822Message:(NSArray *)mails toDirectory:(NSString *)directory
{
	NSManagedObject   *mail;
	NSEnumerator      *enumerator	= [mails objectEnumerator];
	NSAutoreleasePool *pool;
	NSString          *filename;
	
	while (mail = [enumerator nextObject]) {
		pool     = [[NSAutoreleasePool alloc] init];
		filename = nil;
		
		if ([[[mail entity] name] isEqual:@"LightMail"]) {
			filename = [NSString stringWithFormat:@"lightmail_%d_%d_%d_%s.txt",
				[[mail valueForKeyPath:@"folder.order"] intValue],
				[[mail valueForKey:@"index"] intValue],
				[[mail valueForKey:@"status"] intValue],
 [[mail valueForKey:@"secured"] boolValue] ? "ON": "OFF"];
		} if ([[[mail entity] name] isEqual:@"EMail"]) {
			filename = [NSString stringWithFormat:@"email_%d_%d_%d_%s.eml",
				[[mail valueForKeyPath:@"folder.order"] intValue],
				[[mail valueForKey:@"index"] intValue],
				[[mail valueForKey:@"status"] intValue],
 [[mail valueForKey:@"secured"] boolValue] ? "ON": "OFF"];
		}
		if (filename) {
			[[mail valueForKey:@"message"] writeToFile:[directory stringByAppendingPathComponent:filename]
											atomically:YES];
		}
		[pool release];
	}
}

- (void)writeVMessageOfMails:(NSArray *)mails toDirectory:(NSString *)directory
{
	NSManagedObject   *mail;
	NSEnumerator      *enumerator = [mails objectEnumerator];
	
	NSAutoreleasePool *pool;
	NSString          *vmgHeader;
	NSString          *vmgFooter  = @"END:VBODY\r\nEND:VENV\r\nEND:VMSG\r\n";
	
	NSMutableData     *inboxData  = [NSMutableData dataWithCapacity:[mails count] * 256];
	NSMutableData     *outboxData = [NSMutableData dataWithCapacity:[mails count] * 256];
	
	while (mail = [enumerator nextObject]) {
		pool	= [[NSAutoreleasePool alloc] init];
		
		NSString	*irmcStatus	= ([[mail valueForKey:@"status"] intValue] == 2) ? @"READ": @"UNREAD";
		NSString	*irmcType	= ([[[mail entity] name] isEqual:@"LightMail"]) ? @"SMS" : @"INET";
		NSString	*irmcBox;
		NSString	*wx310kMailFolder;
		switch ([[mail valueForKeyPath:@"folder.order"] intValue]) {
			case WXKMailSentMailBox:
				irmcBox = @"SENTBOX";
				wx310kMailFolder = @"SENT";
				break;
			case WXKMailDraftMailBox:
				irmcBox = @"SENTBOX";
				wx310kMailFolder = @"SENT";
				break;
			case WXKMailInboxMailBox:
				irmcBox = @"INBOX";
				wx310kMailFolder = @"DEFAULT";
				break;
			default:
				irmcBox = @"INBOX";
				wx310kMailFolder = @"DEFAULT";
		}
		
		NSString* wx310kProtect = [[mail valueForKey:@"secured"] boolValue] ? @"ON": @"OFF";
		
		vmgHeader = [NSString stringWithFormat:@"BEGIN:VMSG\r\n"
									 @"VERSION:1.1\r\n"
							   @"X-IRMC-STATUS:%@\r\n"
								 @"X-IRMC-TYPE:%@\r\n"
								  @"X-IRMC-BOX:%@\r\n"
						 @"X-WX310K-MAILFOLDER:%@\r\n"
							@"X-WX310K-PROTECT:%@\r\n"
									   @"BEGIN:VENV\r\n"
									   @"BEGIN:VBODY\r\n",
			irmcStatus,
			irmcType,
			irmcBox,
			wx310kMailFolder,
			wx310kProtect];
		
		if ([[[mail entity] name] isEqual:@"LightMail"]) {
			vmgHeader = [vmgHeader stringByAppendingFormat:@"Date:%@\r\nTel:%@\r\n", 
				[[self lightMailDateFormatter] stringFromDate:[mail valueForKey:@"date"]],
				[mail valueForKey:@"object"]];
		}
		
		if ([[mail valueForKeyPath:@"folder.order"] intValue] == WXKMailInboxMailBox) {
			[inboxData appendData:[vmgHeader dataUsingEncoding:NSASCIIStringEncoding]];
			[inboxData appendData:[mail valueForKey:@"message"]];
			[inboxData appendData:[vmgFooter dataUsingEncoding:NSASCIIStringEncoding]];
		} else {
			[outboxData appendData:[vmgHeader dataUsingEncoding:NSASCIIStringEncoding]];
			[outboxData appendData:[mail valueForKey:@"message"]];
			[outboxData appendData:[vmgFooter dataUsingEncoding:NSASCIIStringEncoding]];
		}
		[pool release];
	}
	
	if ([inboxData length] != 0) {
		[inboxData writeToFile:[directory stringByAppendingPathComponent:@"RM310K.vmg"]
					atomically:YES];
	}
	if ([outboxData length] != 0) {
		[outboxData writeToFile:[directory stringByAppendingPathComponent:@"SM310K.vmg"]
					 atomically:YES];
	}
}

@end
